using System;
using System.Windows.Forms;
using DicomObjects;
using DicomObjects.EventArguments;

namespace MPPS_SCU
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : Form
	{
		internal CheckBox EnableLog;
		internal TextBox Logger;
		internal Button InProgressBTN;
		internal Label Label1;
		private DicomDataSetCollection emptydss;
		private string UID, StudyUID;
		internal Button CompleteBTN;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.EnableLog = new CheckBox();
			this.Logger = new TextBox();
			this.CompleteBTN = new Button();
			this.InProgressBTN = new Button();
			this.Label1 = new Label();
			this.SuspendLayout();
			// 
			// EnableLog
			// 
			this.EnableLog.Checked = true;
			this.EnableLog.CheckState = CheckState.Checked;
			this.EnableLog.Location = new System.Drawing.Point(16, 200);
			this.EnableLog.Name = "EnableLog";
			this.EnableLog.Size = new System.Drawing.Size(128, 24);
			this.EnableLog.TabIndex = 9;
			this.EnableLog.Text = "Enable Live Log";
			// 
			// Logger
			// 
			this.Logger.Location = new System.Drawing.Point(176, 64);
			this.Logger.Multiline = true;
			this.Logger.Name = "Logger";
			this.Logger.ScrollBars = ScrollBars.Vertical;
			this.Logger.Size = new System.Drawing.Size(400, 160);
			this.Logger.TabIndex = 8;
			this.Logger.Text = "";
			// 
			// CompleteBTN
			// 
			this.CompleteBTN.Location = new System.Drawing.Point(16, 136);
			this.CompleteBTN.Name = "CompleteBTN";
			this.CompleteBTN.Size = new System.Drawing.Size(128, 64);
			this.CompleteBTN.TabIndex = 7;
			this.CompleteBTN.Text = "Send \"Complete\" Notification";
			this.CompleteBTN.Click += new System.EventHandler(this.CompleteBTN_Click);
			// 
			// InProgressBTN
			// 
			this.InProgressBTN.Location = new System.Drawing.Point(16, 64);
			this.InProgressBTN.Name = "InProgressBTN";
			this.InProgressBTN.Size = new System.Drawing.Size(128, 64);
			this.InProgressBTN.TabIndex = 6;
			this.InProgressBTN.Text = "Send \"In Progress\" Notification";
			this.InProgressBTN.Click += new System.EventHandler(this.InProgressBTN_Click);
			// 
			// Label1
			// 
			this.Label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Label1.Location = new System.Drawing.Point(16, 8);
			this.Label1.Name = "Label1";
			this.Label1.Size = new System.Drawing.Size(552, 48);
			this.Label1.TabIndex = 5;
			this.Label1.Text = "Although reasonably generic, this example is designed to work specifically with e" +
				"ither the corresponding DicomObjects MPPS SCP example, or the DVT Dicom Verifica" +
				"tion Tool ";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(584, 246);
			this.Controls.Add(this.EnableLog);
			this.Controls.Add(this.Logger);
			this.Controls.Add(this.CompleteBTN);
			this.Controls.Add(this.InProgressBTN);
			this.Controls.Add(this.Label1);
			this.Name = "Form1";
			this.Text = "MPPS SCU Sample";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		delegate void SetTextCallback(TextBox box, string text);

		private void AppendText(TextBox box, string text)
		{
			// InvokeRequired required compares the thread ID of the
			// calling thread to the thread ID of the creating thread.
			// If these threads are different, it returns true.
			if (box.InvokeRequired)
			{
				SetTextCallback d = AppendText;
				Invoke(d, new object[] { box, text });
			}
			else
			{
				box.Text = box.Text + text + "\r\n";
			}
		}

		private void DicomGlobal_LogEvent(LogEventArgs e)
		{
			if(EnableLog.Checked)
				AppendText(Logger, e.Text);
		}

		private void Form1_Load(object sender, EventArgs e)
		{
			//Put the following line back to enable DicomObjects Logging
			//DicomGlobal.LogToFile("c:\\dicom log files", 63);
			DicomGlobal.EventLogLevel = (DicomObjects.Enums.LogLevel) 0x3F;
			DicomGlobal.LogEvent +=DicomGlobal_LogEvent;                
			UID = DicomGlobal.NewUID();
			StudyUID = DicomGlobal.NewUID();
		}

		private DicomDataSet MakeBaseDataSet()
		{
			DicomDataSet ds = new DicomDataSet();
			emptydss = new DicomDataSetCollection();

			//set up procedure  details
			ds.Name = "Bloggs^Joe";
			ds.PatientID = "ID1";
			ds.Sex = "M";
			ds.DateOfBirth = Convert.ToDateTime("1962/12/31");

			//Patient
			ds.Add(0x8, 0x1120, emptydss); //"Referenced Patient Sequence"

			//This has basically the info returend in 0040,0100 from MWL
			DicomDataSetCollection dds = new DicomDataSetCollection();
			DicomDataSet ds1 = new DicomDataSet {StudyUID = StudyUID};

		    ds1.Add(0x8, 0x1110, emptydss); // "Referenced Study Sequence"
			ds1.Add(0x8, 0x50, "12345");  // "Accession Number"
			ds1.Add(0x40, 0x1001, "REQ_ID1"); //"Requested Procedure ID"
			ds1.Add(0x32, 0x1060, "Requested Procedure Description");
			ds1.Add(0x40, 0x9, "STEP_ID1"); //"Scheduled Procedure Step ID"
			ds1.Add(0x40, 0x7, "Scheduled Procedure Step Description");

			ds1.Add(0x40, 0x8, emptydss);   // "Scheduled Action Item Code Sequence"

			dds.Add(ds1);
			ds.Add(0x40, 0x270, dds); //"Scheduled Step Attribute Sequence"

			ds.Add(0x40, 0x241, "AETitle"); // "Station AE Title"
			ds.Add(0x40, 0x242, "Station Name"); // Performed Station Name
			ds.Add(0x40, 0x243, "Location"); // Performed Location"
			ds.Add(0x40, 0x244, DateTime.Now); //"Performed Procedure Step Start Date"
			ds.Add(0x40, 0x245, DateTime.Now); //"Performed Procedure Step Start Time"
			ds.Add(0x40, 0x253, "1"); //"Performed Procedure Step ID"
			ds.Add(0x40, 0x250, ""); //"Performed Procedure Step End Date" - not known yet
			ds.Add(0x40, 0x251, ""); //"Performed Procedure Step End Time"- not known yet
			ds.Add(0x40, 0x254, "Performed Procedure Step Description");
			ds.Add(0x40, 0x255, "Performed Procedure Type Description");
			ds.Add(0x8, 0x60, "CT");
			ds.Add(0x20, 0x10, "ID1"); // "Study ID"

			return ds;
		}

		private void InProgressBTN_Click(object sender, EventArgs e)
		{
			DicomDataSet  ds;
			DicomAssociation cn= new DicomAssociation();

			ds = MakeBaseDataSet();

			try
			{
				cn.RequestedContexts.Add("1.2.840.10008.3.1.2.3.3");
				cn.Open("localhost", 104, "CALLING_AE", "CALLED_AE");

				//following sequences are blank at this stage (filled in when MPPS complete)
				// but they must still be present

				ds.Add(0x40, 0x260, emptydss); // "Performed Action Item Sequence"
				ds.Add(0x8, 0x1032, emptydss); // "Procedure Code Sequence"
				ds.Add(0x40, 0x340, emptydss); // "Performed Series Sequence"

				ds.Add(0x40, 0x252, "IN PROGRESS");

				cn.NCreate("1.2.840.10008.3.1.2.3.3", UID, ds);

				if(cn.LastStatus == 0)
					MessageBox.Show("Succeeded");

				cn.Close();
			}
			catch(Exception ex)
			{
				AppendText(Logger, ex.Message.ToString());
			}
		}

		private void CompleteBTN_Click(object sender, EventArgs e)
		{
			DicomDataSet ds;
			DicomAssociation cn = new DicomAssociation();
			DicomDataSet performeditem = new DicomDataSet();
			DicomDataSetCollection performedsequence = new DicomDataSetCollection();
			DicomDataSet actionitem = new DicomDataSet();
			DicomDataSetCollection  actionsequence = new DicomDataSetCollection();
			try
			{
				ds = MakeBaseDataSet();
				cn.RequestedContexts.Add("1.2.840.10008.3.1.2.3.3");
				cn.Open("localhost", 104, "CALLING_AE", "CALLED_AE");

				// These code values are arbitrary, and would be mapped to local/defined codes for real use
				// There is scope for adding more detail of the examination here if required -
				// - see the DICOM standard for details

				// Performed Action Item Sequence
				actionitem.Add(0x8, 0x100, "PAI-1");
				actionitem.Add(0x8, 0x102, "DCMOBJ");
				actionitem.Add(0x8, 0x104, "Performed Action Item 1");
				actionsequence.Add(actionitem);
				ds.Add(0x40, 0x260, actionsequence);

				// Procedure Code Sequence
				performeditem.Add(0x8, 0x100, "PC-1");
				performeditem.Add(0x8, 0x102, "DCMOBJ");
				performeditem.Add(0x8, 0x104, "Procedure Code 1");
				performedsequence.Add(performeditem);
				ds.Add(0x8, 0x1032, performedsequence);

				ds.Add(0x40, 0x340, emptydss); // "Performed Series Sequence"
				ds.Add(0x40, 0x252, "COMPLETED");

				cn.NSet("1.2.840.10008.3.1.2.3.3", UID, ds);

				if(cn.LastStatus == 0) 
					MessageBox.Show("Succeeded");
				cn.Close();
			}
			catch(Exception ex)
			{
				AppendText(Logger, ex.Message.ToString());
			}
		}

	}
}
